#!/bin/sh
###############################################################################
# PACE :: PHP Asynchronous Command Engine
# (C)2022 DP Tech Solutions
# URL:    http://www.pace.tech
# Email:  support@dptechsolutions.com
###############################################################################


umask 0177

echo
echo "Installing PACE"
echo

echo "Check we're running as root"
if [ ! `id -u` = 0 ]; then
	echo
	echo "FAILED: You have to be logged in as root (UID:0) to install csf"
	exit
fi
echo

if [ ! -e "install.sh" ]; then
	echo "You must cd to the package directory that you expanded"
	exit
fi

mkdir -v -m 0600 /usr/local/pace
mkdir -v -m 0600 /usr/local/lib/php
mkdir -v -m 0600 /usr/local/cpanel/whostmgr/docroot/cgi/pace


cp -avf cs/PACE          /etc/chkserv.d
cp -avf in/pace          /etc/init.d
chmod 755 /etc/init.d/pace



cp -avf pace.png         /usr/local/cpanel/whostmgr/docroot/addon_plugins
cp -avf whm/index.php    /usr/local/cpanel/whostmgr/docroot/cgi/pace
cp -avf PACE.php         /usr/local/lib/php
cp -avf pace             /usr/local/pace
cp -avf uninstall.sh     /usr/local/pace
chmod 755 /usr/local/pace/pace

if [ ! -d "/var/cpanel/apps" ]; then
    mkdir /var/cpanel/apps
    chmod 755 /var/cpanel/apps
fi

chmod 600 pace.conf
/usr/local/cpanel/bin/register_appconfig pace.conf


echo
echo "Installation Completed"
echo
